package myBean.mail;

import javax.mail.*;  
import javax.mail.internet.*;  
import java.util.*;
import java.rmi.*;
import javax.activation.*;
import java.io.*;
import myBean.mail.*;

public class MailManager {
	
	//˵һʼʺ: smtpuser@xxx.com
	//POP3_HOST_NAMESMTP_HOST_NAMEֱʼַpop3smtpDNS
	//SMTP_AUTH_USER ="smtpuser", SMTP_AUTH_PWDǸʺŵ

	private  final String POP3_HOST_NAME = "pop3.xxx.com";
	private  final String SMTP_HOST_NAME = "smtp.xxx.com";
	private  final String SMTP_AUTH_USER = "smtpuser";
	private  final String SMTP_AUTH_PWD  = "*****";
	
	
	private Authenticator auth = new Authenticator(){
		public PasswordAuthentication getPasswordAuthentication(){
			return new PasswordAuthentication(SMTP_AUTH_USER, SMTP_AUTH_PWD);
		}
	};
	
	public void sendMail(String toAddr, String subject, 
					String body, String fromAddr, String contentType) {
		try {  
			Properties props = new Properties();  
			
			//ָSMTPʼͨͶ
			props.put("mail.smtp.host", SMTP_HOST_NAME); 
			props.put("mail.smtp.auth", "true");
			
			Session session = Session.getDefaultInstance(props, auth);  
			Message msg = new MimeMessage(session);  
			
			//ָ
			msg.setFrom(new InternetAddress(fromAddr));

			//ָռ
			//InternetAddress[] tos = {new InternetAddress(toAddr)};  
			//msg.setRecipients(Message.RecipientType.TO,tos);
			  
			//ָռˣʱöŷָ 
			InternetAddress[] tos =InternetAddress.parse(toAddr);  
			msg.setRecipients(Message.RecipientType.TO,tos);
			  
			//
			msg.setSubject(subject); 
			
			//
			msg.setText(body); 
			
			//ʱ
			msg.setSentDate(new Date());
			
			//Content-type
			//ͨıΪtext/plain,htmlʽΪtext/html
			msg.setContent(body, contentType);
			
			//
			Transport.send(msg);  
			
		} catch(Exception e){  
			System.out.println(e);  
		}  
	}
	
	public void sendMailWithAttatchment(String toAddr, String subject, String body,
								String fromAddr, String contentType, String []fileList) {
		try {  
			Properties props = new Properties();  
			
			//ָSMTPʼͨͶ
			props.put("mail.smtp.host", SMTP_HOST_NAME); 
			props.put("mail.smtp.auth", "true");

			Session session = Session.getDefaultInstance(props, auth);  
			Message msg = new MimeMessage(session);  
			
			//ָ
			msg.setFrom(new InternetAddress(fromAddr));
			  
			//ָռ
			//InternetAddress[] tos = {new InternetAddress(toAddr)};  
			//msg.setRecipients(Message.RecipientType.TO,tos);

			//ָռˣʱöŷָ 
			InternetAddress[] tos =InternetAddress.parse(toAddr);  
			msg.setRecipients(Message.RecipientType.TO,tos);
			  
			//
			msg.setSubject(subject); 
			
			//ʱ
			msg.setSentDate(new Date());
			
			Multipart multipart = new MimeMultipart();
			MimeBodyPart bodyPart = new MimeBodyPart();
			//
			bodyPart.setText(body);
			//Content-type
			bodyPart.setContent(body, contentType);
			multipart.addBodyPart(bodyPart);
			
			for(int i=0; i<fileList.length; ++i) {
				bodyPart = new MimeBodyPart();
				File f = new File(fileList[i]);
				DataSource source = new FileDataSource(f);
				bodyPart.setDataHandler(new DataHandler(source));
				bodyPart.setFileName(f.getName());
				
				multipart.addBodyPart(bodyPart);
			}
			
			msg.setContent(multipart);

			//
			Transport.send(msg);  
			
		} catch(Exception e){  
			System.out.println(e);  
		}  
	}

	public Mails getMails() {
		Mails mails=null;
		try {  
			//Properties props = System.getProperties();
			Properties props = new Properties(); 			
			props.put("mail.pop3.host", SMTP_HOST_NAME); 
			props.put("mail.pop3.auth", "true");

			Session session = Session.getDefaultInstance(props, auth);
			
			Store store = session.getStore("pop3");
			store.connect();
			
			Folder inbox = store.getFolder("INBOX"); 
			mails = new Mails(inbox);
			store.close();
						
		} catch(Exception e){
			System.out.println(e); 
		}
		
		return mails;
	}
}